#!/usr/bin/env python
# -*- coding: utf-8 -*- 
# -------------------------------------------------------------------------------------
#  Jeśli ustalimy ten sam katalog, nadpisuje pliki
#  Plugin wymaga otwarcia  jakiegoś pliku
# Na podstawie: test-batch-cartoon.py
# Copyright (c) 2013, Jose F. Maldonado
# All rights reserved.
# Redystrybucja i wykorzystanie w postaci źródłowej i binarnej, z modyfikacjami lub bez,
# Są dozwolone pod warunkiem, że spełnione są następujące warunki:
# 	- Redystrybucja kodu źródłowego musi zawierać powyższą informację o prawach autorskich, 
#      niniejszą listę warunków i poniższe zrzeczenie.
#   - Redystrybucji w postaci binarnej muszą zawierać powyższą informację o prawach autorskich, 
#		niniejszą listę warunków i poniższe zrzeczenie w dokumentacji i / lub innych 
#		materiałach dostarczonych wraz z dystrybucją.
#   - Nazwisko autora ani nazwy wspólników firmy nie mogą być używane do celów promowania 
#		produktów wyprowadzonych z niniejszego oprogramowania bez wcześniejszej wyraźnej, 
#		pisemnej zgody.

"""
BSD 3-clause license
Licencja typu BSD skupia się na prawach użytkownika. Jest bardzo liberalna, 
zezwala nie tylko na modyfikacje kodu i jego rozprowadzanie w takiej postaci, 
ale także na rozprowadzanie produktu bez postaci źródłowej czy wręcz włączenia 
do zamkniętego oprogramowania, pod warunkiem załączenia do produktu informacji 
o autorach oryginalnego kodu i treści licencji.
"""

import os
from gimpfu import *

def batch_cartoon(img, layer, inputFolder, outputFolder, maskRadius, blackPct):
    ''' Zastosowanie filtru cartoon (kreskówki) do wszystkich obrazów PNG i JPEG w folderze.
    
    Parametry:
    img : image The current image (niestosowany unused).
    layer : layer The layer of the image that is selected (unused).
    inputFolder : string The folder of the images that must be modified.
    outputFolder : string The folder in which save the modified images.
    maskRadius : float Cartoon mask radius (radius of pixel neighborhood).
    blackPct : float Percentage of darkened pixels to set to black (0.0 - 1.0).
    '''
    # Powtarzanie folderu
    for file in os.listdir(inputFolder):
        try:
            # Budowanie pełnej ścieżki pliku.
            inputPath = inputFolder + "\\" + file
            outputPath = outputFolder + "\\" + file
        
            # Otwórz plik obrazu jeśli jest JPEG lub PNG.
            image = None
            if(file.lower().endswith(('.png'))):
                image = pdb.file_png_load(inputPath, inputPath)
            if(file.lower().endswith(('.jpeg', '.jpg'))):
                image = pdb.file_jpeg_load(inputPath, inputPath)
                
            # Sprawdź czy plik jest obrazem.
            if(image != None):
                # Inwersja obrazu.
                if(len(image.layers) > 0):
                    layer = image.layers[0]
                    pdb.plug_in_cartoon(image, layer, maskRadius, blackPct)
                    
                    # Zapisz obraz.
                    if(file.lower().endswith(('.png'))):
                        pdb.file_png_save(image, image.layers[0], outputPath, outputPath, 0, 9, 0, 0, 0, 0, 0)
                    if(file.lower().endswith(('.jpeg', '.jpg'))):
                        pdb.file_jpeg_save(image, layer, outputPath, outputPath, 0.9, 0, 0, 0, "Creating with GIMP", 0, 0, 0, 0)
        except Exception as err:
            gimp.message("Unexpected error: " + str(err))

register(
    "test_batch_cartoon",
    "Kreskówka wsadowo ",
    "Zastosowanie filtru cartoon (kreskówki) do wszystkich obrazów PNG i JPEG w folderze.",
    "JFM, Modified Zbyma72age",
    "Open source (BSD 3-clause license)",
    "2013, Modified 2015",
    "Kreskówka wsadowo...",
    "*",
    [
        (PF_DIRNAME, "inputFolder", "Katalog wejściowy", ""),
        (PF_DIRNAME, "outputFolder", "Katalog wyjściowy", ""),
        (PF_SLIDER, "maskRadius", "Promień maski", 7, (1,50,1)), # Promień maski rysunku (promień sąsiedztwa pikseli)
        (PF_SLIDER, "blackPct", "Procent ciemnych pikseli", 0.2, (0.0,1.0,0.01))  # Liczba procent zacimnionych pikseli aby ustawić czarne (0.0 - 1.0)
    ],
    [],
    batch_cartoon, menu="<Image>/TEST/Testowanie")

main()
